<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Customer Survey - SI-INAL Asset IT</title>
    <!-- Inter Font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="/SI-INAL/public/assets/css/style.css">
    <style>
        body {
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            background-color: var(--light-bg); /* Use the light neumorphic background */
            padding: 1rem;
        }
        .card {
            border-radius: 1rem;
            box-shadow: var(--neumorphic-shadow-light); /* Use the defined neumorphic shadow */
        }
        /* Custom styling for rating radios */
        .rating-input .form-check-input[type="radio"] {
            /* Hide default radio button */
            opacity: 0;
            width: 0;
            height: 0;
        }

        .rating-input .form-check-label {
            background-color: var(--light-bg);
            border-radius: 0.5rem;
            padding: 0.8rem 1.2rem;
            box-shadow: var(--neumorphic-shadow-light);
            cursor: pointer;
            transition: all 0.2s ease-in-out;
            font-weight: 500;
            color: #6c757d;
            min-width: 50px; /* Ensure uniform size */
            text-align: center;
            margin: 0 5px; /* Spacing between numbers */
        }

        .rating-input .form-check-input[type="radio"]:checked + .form-check-label {
            box-shadow: var(--neumorphic-inset-shadow-light);
            background-color: #f0f0f0; /* Slightly different color when checked */
            color: var(--primary-color);
        }

        .rating-input .form-check-label:hover {
            background-color: #f0f0f0;
            box-shadow: var(--neumorphic-inset-shadow-light); /* Inset shadow on hover */
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-7">
                <!-- Existing survey form content, removed the vh-100 and bg-light-neumorphic from outer div -->
                <div class="card card-neumorphic p-4">
                    <div class="card-body">
                        <h3 class="card-title text-center mb-4 fw-bold">Kuesioner Kepuasan Pelanggan Internal</h3>
                        <p class="text-center text-muted mb-4">Masukan Anda sangat berarti untuk peningkatan layanan kami.</p>

                        <?php if (isset($_GET['message']) && $_GET['message'] == 'survey_success'): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                Terima kasih atas partisipasi Anda dalam survei ini!
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        <?php endif; ?>
                        <?php if (isset($_GET['error'])): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <?php
                                    switch ($_GET['error']) {
                                        case 'submit_failed':
                                            echo "Gagal mengirimkan survei. Silakan coba lagi.";
                                            break;
                                        case 'invalid_rating':
                                            echo "Pilihan rating tidak valid untuk salah satu pertanyaan.";
                                            break;
                                    }
                                ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        <?php endif; ?>

                        <form action="?page=survey_submit" method="POST">
                            <div class="mb-3">
                                <label for="survey_nama" class="form-label">Nama Anda</label>
                                <input type="text" class="form-control" id="survey_nama" name="nama" required>
                            </div>
                            <div class="mb-3">
                                <label for="survey_unit" class="form-label">Unit Anda</label>
                                <input type="text" class="form-control" id="survey_unit" name="unit" required>
                            </div>
                            <div class="mb-3">
                                <label for="survey_email" class="form-label">Email Anda</label>
                                <input type="email" class="form-control" id="survey_email" name="email" required>
                            </div>
                            <?php if (!empty($questions)): ?>
                                <?php foreach ($questions as $question): ?>
                                    <div class="mb-4">
                                        <label class="form-label fw-bold"><?php echo htmlspecialchars($question['question_text']); ?></label>
                                        <?php if ($question['question_type'] === 'rating_5'): ?>
                                            <div class="rating-input d-flex justify-content-center mt-2">
                                                <?php for ($i = 1; $i <= 5; $i++): ?>
                                                    <div class="form-check form-check-inline mx-2">
                                                        <input class="form-check-input" type="radio" name="question_<?php echo $question['id']; ?>" id="question_<?php echo $question['id'] . '_' . $i; ?>" value="<?php echo $i; ?>" required>
                                                        <label class="form-check-label" for="question_<?php echo $question['id'] . '_' . $i; ?>"><?php echo $i; ?></label>
                                                    </div>
                                                <?php endfor; ?>
                                            </div>
                                        <?php elseif ($question['question_type'] === 'text'): ?>
                                            <textarea class="form-control" name="question_<?php echo $question['id']; ?>" rows="3" placeholder="Masukkan komentar atau saran Anda"></textarea>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <div class="alert alert-warning">Tidak ada pertanyaan survei yang tersedia saat ini.</div>
                            <?php endif; ?>

                            <div class="d-grid gap-2 mt-4">
                                <button type="submit" class="btn btn-primary btn-neumorphic-sm py-2">Kirim Survei</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Bootstrap JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
</body>
</html>