<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Manajemen Vendor SLA</h1>

    <?php if (isset($_GET['message'])): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php
                switch ($_GET['message']) {
                    case 'vendor_added':
                        echo "Vendor berhasil ditambahkan.";
                        break;
                }
            ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <?php if (isset($_GET['error'])): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php
                switch ($_GET['error']) {
                    case 'add_failed':
                        echo "Gagal menambahkan vendor. Silakan coba lagi.";
                        break;
                }
            ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">Daftar Vendor</h6>
            <a href="?page=sla_vendors_create" class="btn btn-primary btn-sm">Tambah Vendor Baru</a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>Vendor</th>
                            <th>Layanan</th>
                            <th>Kontak</th>
                            <th>SLA Uptime</th>
                            <th>SLA Respon (Menit)</th>
                            <th>Aksi</th> <!-- Tambah kolom aksi jika ingin edit/delete vendor -->
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($vendors)): ?>
                            <?php foreach ($vendors as $vendor): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($vendor['nama_vendor']); ?></td>
                                    <td><?php echo htmlspecialchars($vendor['jenis_layanan']); ?></td>
                                    <td><?php echo htmlspecialchars($vendor['kontak_vendor']); ?></td>
                                    <td><?php echo htmlspecialchars($vendor['sla_uptime_percentage']); ?>%</td>
                                    <td><?php echo htmlspecialchars($vendor['sla_response_time_minutes']); ?></td>
                                    <td>
                                        <!-- Add edit/delete buttons here if needed -->
                                        <a href="#" class="btn btn-info btn-sm disabled">Edit</a>
                                        <button type="button" class="btn btn-danger btn-sm disabled">Hapus</button>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="6" class="text-center">Belum ada vendor ditambahkan.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
