<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Riwayat Maintenance Global</h1>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Daftar Semua Riwayat Maintenance</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>ID Aset</th>
                            <th>Nama Perangkat</th>
                            <th>Kategori Aset</th>
                            <th>Tanggal Maintenance</th>
                            <th>Tindakan</th>
                            <th>Teknisi</th>
                            <th>Kondisi Akhir</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($all_maintenance_history)): ?>
                            <?php foreach ($all_maintenance_history as $history): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($history['id_aset']); ?></td>
                                    <td><?php echo htmlspecialchars($history['nama_perangkat']); ?></td>
                                    <td><?php echo htmlspecialchars($history['asset_kategori']); ?></td>
                                    <td><?php echo htmlspecialchars($history['tanggal_maintenance']); ?></td>
                                    <td><?php echo htmlspecialchars($history['tindakan']); ?></td>
                                    <td><?php echo htmlspecialchars($history['nama_teknisi']); ?></td>
                                    <td>
                                        <?php
                                            $kondisi_akhir = 'N/A';
                                            if (isset($history['assessment_data']) && !empty($history['assessment_data'])) {
                                                $assessment = json_decode($history['assessment_data'], true);
                                                if (isset($assessment['status_akhir']['kondisi'])) {
                                                    $kondisi_akhir = $assessment['status_akhir']['kondisi'];
                                                }
                                            }
                                            echo htmlspecialchars($kondisi_akhir);
                                        ?>
                                    </td>
                                    <td>
                                        <a href="?page=maintenance&id=<?php echo htmlspecialchars($history['id_aset']); ?>" class="btn btn-info btn-sm">Lihat Detail Aset</a>
                                        <!-- Optionally, add a button to view specific assessment details in a modal here too -->
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="8" class="text-center">Tidak ada riwayat maintenance ditemukan.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
