<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800 fw-bold">KPI Internal IT</h1>

    <!-- Filter Form for Month and Year -->
    <div class="card card-neumorphic mb-4">
        <div class="card-header bg-transparent border-0 py-3">
            <h6 class="m-0 fw-bold text-dark">Filter KPI</h6>
        </div>
        <div class="card-body">
            <form action="?page=kpi_it" method="GET" class="row g-3 align-items-end">
                <input type="hidden" name="page" value="kpi_it">
                <div class="col-md-4">
                    <label for="month" class="form-label">Bulan:</label>
                    <select class="form-select" id="month" name="month" required>
                        <?php for ($i = 1; $i <= 12; $i++): ?>
                            <option value="<?php echo $i; ?>" <?php echo (isset($filters['month']) && $filters['month'] == $i) ? 'selected' : ''; ?>>
                                <?php echo date('F', mktime(0, 0, 0, $i, 10)); ?>
                            </option>
                        <?php endfor; ?>
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="year" class="form-label">Tahun:</label>
                    <select class="form-select" id="year" name="year" required>
                        <?php for ($i = date('Y') - 2; $i <= date('Y') + 1; $i++): ?>
                            <option value="<?php echo $i; ?>" <?php echo (isset($filters['year']) && $filters['year'] == $i) ? 'selected' : ''; ?>>
                                <?php echo $i; ?>
                            </option>
                        <?php endfor; ?>
                    </select>
                </div>
                <div class="col-md-4 d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary btn-neumorphic-sm me-2">Filter</button>
                    <a href="?page=kpi_it" class="btn btn-warning btn-neumorphic-sm">Reset</a>
                </div>
            </form>
        </div>
    </div>
    <!-- End Filter Form -->

    <div class="row g-4 mb-4">
        <!-- KPI 1: Kerusakan Device -->
        <div class="col-lg-4 col-md-6">
            <div class="card card-neumorphic card-accent-danger">
                <div class="card-body text-center">
                    <div class="text-muted text-uppercase mb-2">Kerusakan Device</div>
                    <div class="fw-bold fs-2 text-danger"><?php echo number_format($kpi_device_damage_percentage, 2); ?>%</div>
                    <div class="text-muted small">Target: &lt;5%</div>
                </div>
            </div>
        </div>

        <!-- KPI 2: Biaya Pengadaan Tinta -->
        <div class="col-lg-4 col-md-6">
            <div class="card card-neumorphic card-accent-info">
                <div class="card-body text-center">
                    <div class="text-muted text-uppercase mb-2">Biaya Pengadaan Tinta</div>
                    <div class="fw-bold fs-2 text-info">Rp <?php echo number_format($kpi_ink_procurement_cost, 0, ',', '.'); ?></div>
                    <div class="text-muted small">Target: Max Rp 1.500.000 /bulan</div>
                </div>
            </div>
        </div>

        <!-- KPI 3: Kepuasan Pelanggan Internal -->
        <div class="col-lg-4 col-md-6">
            <div class="card card-neumorphic card-accent-success">
                <div class="card-body text-center">
                    <div class="text-muted text-uppercase mb-2">Kepuasan Pelanggan Internal</div>
                    <div class="fw-bold fs-2 text-success"><?php echo number_format($kpi_customer_satisfaction, 2); ?>%</div>
                    <div class="text-muted small">Target: &gt;85%</div>
                </div>
            </div>
        </div>

        <!-- KPI 4: Response Time Help Desk -->
        <div class="col-lg-4 col-md-6">
            <div class="card card-neumorphic card-accent-warning">
                <div class="card-body text-center">
                    <div class="text-muted text-uppercase mb-2">Response Time Help Desk</div>
                    <div class="fw-bold fs-2 text-warning"><?php echo number_format($kpi_avg_helpdesk_response_time, 0); ?> Menit</div>
                    <div class="text-muted small">Target: &lt;30 Menit</div>
                </div>
            </div>
        </div>

        <!-- KPI 5: Tersosialisasinya perubahan sistem -->
        <div class="col-lg-4 col-md-6">
            <div class="card card-neumorphic card-accent-primary">
                <div class="card-body text-center">
                    <div class="text-muted text-uppercase mb-2">Sosialisasi Perubahan Sistem</div>
                    <div class="fw-bold fs-2 text-primary"><?php echo htmlspecialchars($kpi_system_change_socialization); ?></div>
                    <div class="text-muted small">Target: 1x24 Jam</div>
                </div>
            </div>
        </div>

        <!-- KPI 6: Preventive Maintenance Hardware -->
        <div class="col-lg-4 col-md-6">
            <div class="card card-neumorphic card-accent-secondary">
                <div class="card-body text-center">
                    <div class="text-muted text-uppercase mb-2">Preventive Maintenance Hardware</div>
                    <div class="fw-bold fs-2 text-secondary"><?php echo number_format($kpi_preventive_maintenance_percentage, 2); ?>%</div>
                    <div class="text-muted small">Target: 90% /Bulan</div>
                </div>
            </div>
        </div>

        <!-- KPI 7: Penerapan 5R -->
        <div class="col-lg-4 col-md-6">
            <div class="card card-neumorphic card-accent-dark">
                <div class="card-body text-center">
                    <div class="text-muted text-uppercase mb-2">Penerapan 5R</div>
                    <div class="fw-bold fs-2 text-dark"><?php echo htmlspecialchars($kpi_5r_implementation); ?></div>
                    <div class="text-muted small">Target: Tercapai</div>
                </div>
            </div>
        </div>

        <!-- KPI 8: Downtime -->
        <div class="col-lg-4 col-md-6">
            <div class="card card-neumorphic card-accent-light">
                <div class="card-body text-center">
                    <div class="text-muted text-uppercase mb-2">Downtime</div>
                    <div class="fw-bold fs-2 text-body">
                        <?php 
                            echo htmlspecialchars($kpi_downtime_result['incidents_over_30_min']);
                            if ($kpi_downtime_result['kpi_met']) {
                                echo " <i class='bi bi-check-circle-fill text-success'></i>";
                            } else {
                                echo " <i class='bi bi-x-circle-fill text-danger'></i>";
                            }
                        ?>
                    </div>
                    <div class="text-muted small">Target: &lt;3 insiden/bln (&lt;30mnt)</div>
                    <div class="text-muted small">(<?php echo htmlspecialchars($kpi_downtime_result['total_incidents']); ?> total insiden)</div>
                </div>
            </div>
        </div>

        <!-- KPI 9: Implementasi Lean Management -->
        <div class="col-lg-4 col-md-6">
            <div class="card card-neumorphic card-accent-dark">
                <div class="card-body text-center">
                    <div class="text-muted text-uppercase mb-2">Implementasi Lean Management (Kaizen)</div>
                    <div class="fw-bold fs-2 text-dark"><?php echo htmlspecialchars($kpi_lean_management_implementation); ?></div>
                    <div class="text-muted small">Target: Tercapai</div>
                </div>
            </div>
        </div>
    </div>
</div>
