<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Detail Tiket Helpdesk #<?php echo htmlspecialchars($ticket_data->id_ticket); ?></h1>

    <?php if (isset($_GET['message']) && $_GET['message'] == 'update_success'): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            Tiket berhasil diperbarui!
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    <?php if (isset($_GET['error'])): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php
                switch ($_GET['error']) {
                    case 'update_failed':
                        echo "Gagal memperbarui tiket. Silakan coba lagi.";
                        break;
                }
            ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-lg-7">
            <div class="card card-neumorphic mb-4">
                <div class="card-header bg-transparent border-0 py-3">
                    <h6 class="m-0 fw-bold text-dark">Informasi Tiket</h6>
                </div>
                <div class="card-body">
                    <p><strong>ID Tiket:</strong> <?php echo htmlspecialchars($ticket_data->id_ticket); ?></p>
                    <p><strong>Kategori Masalah:</strong> <?php echo htmlspecialchars($ticket_data->category); ?></p> <!-- New -->
                    <p><strong>Unit Pelapor:</strong> <?php echo htmlspecialchars($ticket_data->unit); ?></p> <!-- New -->
                    <p><strong>Pelapor:</strong> <?php echo htmlspecialchars($ticket_data->reporter_name); ?></p>
                    <p><strong>Deskripsi Masalah:</strong><br><?php echo nl2br(htmlspecialchars($ticket_data->problem_description)); ?></p>
                    <p><strong>Dibuat Pada:</strong> <?php echo htmlspecialchars(date('d-m-Y H:i', strtotime($ticket_data->created_at))); ?></p>
                    <p><strong>Terakhir Diperbarui:</strong> <?php echo htmlspecialchars(date('d-m-Y H:i', strtotime($ticket_data->updated_at))); ?></p>
                </div>
            </div>
        </div>
        <div class="col-lg-5">
            <div class="card card-neumorphic mb-4">
                <div class="card-header bg-transparent border-0 py-3">
                    <h6 class="m-0 fw-bold text-dark">Update Tiket</h6>
                </div>
                <div class="card-body">
                    <form action="?page=helpdesk_update_ticket" method="POST">
                        <input type="hidden" name="id_ticket" value="<?php echo htmlspecialchars($ticket_data->id_ticket); ?>">
                        
                        <div class="mb-3">
                            <label for="status" class="form-label">Status:</label>
                            <select class="form-select" id="status" name="status">
                                <option value="New" <?php echo ($ticket_data->status == 'New') ? 'selected' : ''; ?>>New</option>
                                <option value="In Progress" <?php echo ($ticket_data->status == 'In Progress') ? 'selected' : ''; ?>>In Progress</option>
                                <option value="Resolved" <?php echo ($ticket_data->status == 'Resolved') ? 'selected' : ''; ?>>Resolved</option>
                                <option value="Closed" <?php echo ($ticket_data->status == 'Closed') ? 'selected' : ''; ?>>Closed</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="priority" class="form-label">Prioritas:</label>
                            <select class="form-select" id="priority" name="priority">
                                <option value="Low" <?php echo ($ticket_data->priority == 'Low') ? 'selected' : ''; ?>>Low</option>
                                <option value="Medium" <?php echo ($ticket_data->priority == 'Medium') ? 'selected' : ''; ?>>Medium</option>
                                <option value="High" <?php echo ($ticket_data->priority == 'High') ? 'selected' : ''; ?>>High</option>
                                <option value="Critical" <?php echo ($ticket_data->priority == 'Critical') ? 'selected' : ''; ?>>Critical</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="assigned_to_user_id" class="form-label">Tugaskan ke:</label>
                            <select class="form-select" id="assigned_to_user_id" name="assigned_to_user_id">
                                <option value="">-- Pilih Petugas --</option>
                                <?php if (!empty($users)): ?>
                                    <?php foreach ($users as $user): ?>
                                        <option value="<?php echo htmlspecialchars($user['id_user']); ?>"
                                            <?php echo ($ticket_data->assigned_to_user_id == $user['id_user']) ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($user['nama_lengkap']); ?> (<?php echo htmlspecialchars($user['role']); ?>)
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="response_at" class="form-label">Waktu Respons:</label>
                            <input type="text" class="form-control" id="response_at" value="<?php echo htmlspecialchars($ticket_data->response_at ?? 'Belum direspons'); ?>" readonly>
                        </div>
                        <div class="mb-3">
                            <label for="resolved_at" class="form-label">Waktu Selesai:</label>
                            <input type="text" class="form-control" id="resolved_at" value="<?php echo htmlspecialchars($ticket_data->resolved_at ?? 'Belum selesai'); ?>" readonly>
                        </div>
                        <div class="mb-3">
                            <label for="resolution_details" class="form-label">Detail Resolusi:</label>
                            <textarea class="form-control" id="resolution_details" name="resolution_details" rows="3"><?php echo htmlspecialchars($ticket_data->resolution_details ?? ''); ?></textarea>
                        </div>
                        <button type="submit" class="btn btn-primary btn-neumorphic-sm">Update Tiket</button>
                        <a href="?page=helpdesk_tickets" class="btn btn-warning btn-neumorphic-sm">Kembali</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
